#ifndef __IToolTipSupportingWindow__
#define __IToolTipSupportingWindow__

#include "IToolTip.hpp"
using Exponent::GUI::Windowing::IToolTip;

//	===========================================================================

namespace Exponent
{
	namespace GUI
	{
		namespace Windowing
		{
			/**
			 * @interface IToolTipSupportingWindow IToolTipSupportingWindow.hpp
			 * @brief Specifies a window that can support a tooltip
			 *
			 * @date 18/03/2005
			 * @author Paul Chana
			 * @version 1.0.0 Initial version
			 *
			 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
			 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
			 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
			 * All content is the Intellectual property of Exp Digital Uk.\n
			 * Certain sections of this code may come from other sources. They are credited where applicable.\n
			 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
			 *
			 * $Id: IToolTipSupportingWindow.hpp,v 1.4 2007/02/08 21:07:54 paul Exp $
			 */
			interface IToolTipSupportingWindow
			{

//	===========================================================================

			public:

//	===========================================================================

				/**
				 * Construction
				 */
				IToolTipSupportingWindow() { }
				
				/**
				 * Destruction
				 */
				virtual ~IToolTipSupportingWindow() { }

//	===========================================================================

				/**
				 * Set the tooltip to display
				 * @param toolTip The tool tip to display
				 */
				virtual void setToolTip(IToolTip *toolTip = NULL) = 0;

				/**
				 * Get the mutable tool tip
				 * @retval IToolTip* The tool tip
				 */
				virtual IToolTip *getMutableToolTip() const = 0;

				/**
				 * Get the tool tip
				 * @retval const IToolTip* The tool tip
				 */
				virtual const IToolTip *getToolTip() const = 0;

//	===========================================================================

			};
		}
	}
}
#endif	// End of IToolTipSupportingWindow.hpp